/*
 * Decompiled with CFR 0.152.
 */
package satisfyu.candlelight.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfyu.candlelight.registry.ArmorMaterialRegistry;

public class RingItem
extends ArmorItem {
    public RingItem(ArmorMaterial material, EquipmentSlot slot, Item.Properties settings) {
        super(material, slot, settings);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.m_5776_() && entity instanceof Player) {
            Player player = (Player)entity;
            this.checkForSet(player);
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    private void checkForSet(Player player) {
        if (this.hasRing(player)) {
            this.addStatusEffect(player, new MobEffectInstance(MobEffects.f_19621_, 280, 1));
        }
    }

    private boolean hasRing(Player player) {
        if (player.m_150109_().m_36052_(2).m_41619_()) {
            return false;
        }
        Item item = player.m_150109_().m_36052_(2).m_41720_();
        if (item instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)item;
            return armorItem.m_40401_() == ArmorMaterialRegistry.RING_ARMOR;
        }
        return false;
    }

    private void addStatusEffect(Player player, MobEffectInstance mapStatusEffect) {
        boolean hasPlayerEffect = player.m_21023_(mapStatusEffect.m_19544_());
        MobEffectInstance effect = player.m_21124_(mapStatusEffect.m_19544_());
        if (!hasPlayerEffect || effect != null && effect.m_19557_() < 220) {
            player.m_7292_(new MobEffectInstance(mapStatusEffect.m_19544_(), mapStatusEffect.m_19557_(), mapStatusEffect.m_19564_(), true, false, true));
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"item.candlelight.ring1.tooltip").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)Component.m_237115_((String)"item.candlelight.ring2.tooltip").m_130940_(ChatFormatting.WHITE));
        tooltip.add((Component)Component.m_237115_((String)"item.candlelight.ring3.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

